/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.pathprovider;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugins.pathprovider.Messages;
import io.flutter.util.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PathProviderPlugin
implements FlutterPlugin,
Messages.PathProviderApi {
    static final String TAG = "PathProviderPlugin";
    private Context context;

    private void setUp(BinaryMessenger messenger, Context context) {
        try {
            Messages.PathProviderApi.setUp(messenger, this);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Received exception while setting up PathProviderPlugin", (Throwable)ex);
        }
        this.context = context;
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.setUp(binding.getBinaryMessenger(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        Messages.PathProviderApi.setUp(binding.getBinaryMessenger(), null);
    }

    @Override
    @Nullable
    public String getTemporaryPath() {
        return this.context.getCacheDir().getPath();
    }

    @Override
    @Nullable
    public String getApplicationSupportPath() {
        return PathUtils.getFilesDir((Context)this.context);
    }

    @Override
    @Nullable
    public String getApplicationDocumentsPath() {
        return PathUtils.getDataDirectory((Context)this.context);
    }

    @Override
    @Nullable
    public String getApplicationCachePath() {
        return this.context.getCacheDir().getPath();
    }

    @Override
    @Nullable
    public String getExternalStoragePath() {
        File dir = this.context.getExternalFilesDir(null);
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    @Override
    @NonNull
    public List<String> getExternalCachePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (File dir : this.context.getExternalCacheDirs()) {
            if (dir == null) continue;
            paths.add(dir.getAbsolutePath());
        }
        return paths;
    }

    @Override
    @NonNull
    public List<String> getExternalStoragePaths(@NonNull Messages.StorageDirectory directory) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File dir : this.context.getExternalFilesDirs(this.getStorageDirectoryString(directory))) {
            if (dir == null) continue;
            paths.add(dir.getAbsolutePath());
        }
        return paths;
    }

    @VisibleForTesting
    String getStorageDirectoryString(@NonNull Messages.StorageDirectory directory) {
        switch (directory) {
            case ROOT: {
                return null;
            }
            case MUSIC: {
                return "music";
            }
            case PODCASTS: {
                return "podcasts";
            }
            case RINGTONES: {
                return "ringtones";
            }
            case ALARMS: {
                return "alarms";
            }
            case NOTIFICATIONS: {
                return "notifications";
            }
            case PICTURES: {
                return "pictures";
            }
            case MOVIES: {
                return "movies";
            }
            case DOWNLOADS: {
                return "downloads";
            }
            case DCIM: {
                return "dcim";
            }
            case DOCUMENTS: {
                return "documents";
            }
        }
        throw new RuntimeException("Unrecognized directory: " + (Object)((Object)directory));
    }
}

