/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage.ciphers;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.it_nomads.fluttersecurestorage.ciphers.KeyCipher;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;

class RSACipher18Implementation
implements KeyCipher {
    private static final String KEYSTORE_PROVIDER_ANDROID = "AndroidKeyStore";
    private static final String TYPE_RSA = "RSA";
    protected final String keyAlias;
    protected final Context context;

    public RSACipher18Implementation(Context context) throws Exception {
        this.context = context;
        this.keyAlias = this.createKeyAlias();
        this.createRSAKeysIfNeeded(context);
    }

    protected String createKeyAlias() {
        return this.context.getPackageName() + ".FlutterSecureStoragePluginKey";
    }

    @Override
    public byte[] wrap(Key key) throws Exception {
        PublicKey publicKey = this.getPublicKey();
        Cipher cipher = this.getRSACipher();
        cipher.init(3, (Key)publicKey, this.getAlgorithmParameterSpec());
        return cipher.wrap(key);
    }

    @Override
    public Key unwrap(byte[] wrappedKey, String algorithm) throws Exception {
        PrivateKey privateKey = this.getPrivateKey();
        Cipher cipher = this.getRSACipher();
        cipher.init(4, (Key)privateKey, this.getAlgorithmParameterSpec());
        return cipher.unwrap(wrappedKey, algorithm, 3);
    }

    private PrivateKey getPrivateKey() throws Exception {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        Key key = ks.getKey(this.keyAlias, null);
        if (key == null) {
            throw new Exception("No key found under alias: " + this.keyAlias);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception("Not an instance of a PrivateKey");
        }
        return (PrivateKey)key;
    }

    private PublicKey getPublicKey() throws Exception {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        Certificate cert = ks.getCertificate(this.keyAlias);
        if (cert == null) {
            throw new Exception("No certificate found under alias: " + this.keyAlias);
        }
        PublicKey key = cert.getPublicKey();
        if (key == null) {
            throw new Exception("No key found under alias: " + this.keyAlias);
        }
        return key;
    }

    protected Cipher getRSACipher() throws Exception {
        if (Build.VERSION.SDK_INT < 23) {
            return Cipher.getInstance("RSA/ECB/PKCS1Padding", "AndroidOpenSSL");
        }
        return Cipher.getInstance("RSA/ECB/PKCS1Padding", "AndroidKeyStoreBCWorkaround");
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return null;
    }

    private void createRSAKeysIfNeeded(Context context) throws Exception {
        KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID);
        ks.load(null);
        Key privateKey = ks.getKey(this.keyAlias, null);
        if (privateKey == null) {
            this.createKeys(context);
        }
    }

    private void setLocale(Locale locale) {
        Locale.setDefault(locale);
        Configuration config = this.context.getResources().getConfiguration();
        config.setLocale(locale);
        this.context.createConfigurationContext(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeys(Context context) throws Exception {
        Locale localeBeforeFakingEnglishLocale = Locale.getDefault();
        try {
            this.setLocale(Locale.ENGLISH);
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 25);
            KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance(TYPE_RSA, KEYSTORE_PROVIDER_ANDROID);
            AlgorithmParameterSpec spec = Build.VERSION.SDK_INT < 23 ? this.makeAlgorithmParameterSpecLegacy(context, start, end) : this.makeAlgorithmParameterSpec(context, start, end);
            kpGenerator.initialize(spec);
            kpGenerator.generateKeyPair();
        }
        finally {
            this.setLocale(localeBeforeFakingEnglishLocale);
        }
    }

    private AlgorithmParameterSpec makeAlgorithmParameterSpecLegacy(Context context, Calendar start, Calendar end) {
        return new KeyPairGeneratorSpec.Builder(context).setAlias(this.keyAlias).setSubject(new X500Principal("CN=" + this.keyAlias)).setSerialNumber(BigInteger.valueOf(1L)).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
    }

    @RequiresApi(api=23)
    protected AlgorithmParameterSpec makeAlgorithmParameterSpec(Context context, Calendar start, Calendar end) {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.keyAlias, 3).setCertificateSubject(new X500Principal("CN=" + this.keyAlias)).setDigests(new String[]{"SHA-256"}).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setCertificateSerialNumber(BigInteger.valueOf(1L)).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime());
        return builder.build();
    }
}

