/*
 * Decompiled with CFR 0.152.
 */
package com.it_nomads.fluttersecurestorage;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.it_nomads.fluttersecurestorage.FlutterSecureStorage;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class FlutterSecureStoragePlugin
implements MethodChannel.MethodCallHandler,
FlutterPlugin {
    private static final String TAG = "FlutterSecureStoragePl";
    private MethodChannel channel;
    private FlutterSecureStorage secureStorage;
    private HandlerThread workerThread;
    private Handler workerThreadHandler;

    public void initInstance(BinaryMessenger messenger, Context context) {
        try {
            this.secureStorage = new FlutterSecureStorage(context, new HashMap<String, Object>());
            this.workerThread = new HandlerThread("com.it_nomads.fluttersecurestorage.worker");
            this.workerThread.start();
            this.workerThreadHandler = new Handler(this.workerThread.getLooper());
            this.channel = new MethodChannel(messenger, "plugins.it_nomads.com/flutter_secure_storage");
            this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Registration failed", (Throwable)e);
        }
    }

    public void onAttachedToEngine(FlutterPlugin.FlutterPluginBinding binding) {
        this.initInstance(binding.getBinaryMessenger(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.channel != null) {
            this.workerThread.quitSafely();
            this.workerThread = null;
            this.channel.setMethodCallHandler(null);
            this.channel = null;
        }
        this.secureStorage = null;
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result rawResult) {
        MethodResultWrapper result = new MethodResultWrapper(rawResult);
        this.workerThreadHandler.post((Runnable)new MethodRunner(call, result));
    }

    private String getKeyFromCall(MethodCall call) {
        Map arguments = (Map)call.arguments;
        return this.secureStorage.addPrefixToKey((String)arguments.get("key"));
    }

    private String getValueFromCall(MethodCall call) {
        Map arguments = (Map)call.arguments;
        return (String)arguments.get("value");
    }

    static class MethodResultWrapper
    implements MethodChannel.Result {
        private final MethodChannel.Result methodResult;
        private final Handler handler = new Handler(Looper.getMainLooper());

        MethodResultWrapper(MethodChannel.Result methodResult) {
            this.methodResult = methodResult;
        }

        public void success(Object result) {
            this.handler.post(() -> this.methodResult.success(result));
        }

        public void error(@NonNull String errorCode, String errorMessage, Object errorDetails) {
            this.handler.post(() -> this.methodResult.error(errorCode, errorMessage, errorDetails));
        }

        public void notImplemented() {
            this.handler.post(() -> ((MethodChannel.Result)this.methodResult).notImplemented());
        }
    }

    class MethodRunner
    implements Runnable {
        private final MethodCall call;
        private final MethodChannel.Result result;

        MethodRunner(MethodCall call, MethodChannel.Result result) {
            this.call = call;
            this.result = result;
        }

        @Override
        public void run() {
            boolean resetOnError = false;
            try {
                ((FlutterSecureStoragePlugin)FlutterSecureStoragePlugin.this).secureStorage.options = (Map)((Map)this.call.arguments).get("options");
                FlutterSecureStoragePlugin.this.secureStorage.ensureOptions();
                resetOnError = FlutterSecureStoragePlugin.this.secureStorage.getResetOnError();
                switch (this.call.method) {
                    case "write": {
                        String key = FlutterSecureStoragePlugin.this.getKeyFromCall(this.call);
                        String value = FlutterSecureStoragePlugin.this.getValueFromCall(this.call);
                        if (value != null) {
                            FlutterSecureStoragePlugin.this.secureStorage.write(key, value);
                            this.result.success(null);
                            break;
                        }
                        this.result.error("null", null, null);
                        break;
                    }
                    case "read": {
                        String key = FlutterSecureStoragePlugin.this.getKeyFromCall(this.call);
                        if (FlutterSecureStoragePlugin.this.secureStorage.containsKey(key)) {
                            String value = FlutterSecureStoragePlugin.this.secureStorage.read(key);
                            this.result.success((Object)value);
                            break;
                        }
                        this.result.success(null);
                        break;
                    }
                    case "readAll": {
                        this.result.success(FlutterSecureStoragePlugin.this.secureStorage.readAll());
                        break;
                    }
                    case "containsKey": {
                        String key = FlutterSecureStoragePlugin.this.getKeyFromCall(this.call);
                        boolean containsKey = FlutterSecureStoragePlugin.this.secureStorage.containsKey(key);
                        this.result.success((Object)containsKey);
                        break;
                    }
                    case "delete": {
                        String key = FlutterSecureStoragePlugin.this.getKeyFromCall(this.call);
                        FlutterSecureStoragePlugin.this.secureStorage.delete(key);
                        this.result.success(null);
                        break;
                    }
                    case "deleteAll": {
                        FlutterSecureStoragePlugin.this.secureStorage.deleteAll();
                        this.result.success(null);
                        break;
                    }
                    default: {
                        this.result.notImplemented();
                        break;
                    }
                }
            }
            catch (FileNotFoundException e) {
                Log.i((String)"Creating sharedPrefs", (String)e.getLocalizedMessage());
            }
            catch (Exception e) {
                if (resetOnError) {
                    try {
                        FlutterSecureStoragePlugin.this.secureStorage.deleteAll();
                        this.result.success((Object)"Data has been reset");
                    }
                    catch (Exception ex) {
                        this.handleException(ex);
                    }
                }
                this.handleException(e);
            }
        }

        private void handleException(Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.result.error("Exception encountered", this.call.method, (Object)stringWriter.toString());
        }
    }
}

