@extends('layouts.admin.app')
@section('title', \App\CPU\translate('recaptcha_setup'))
@push('css_or_js')
    <link rel="stylesheet" href="{{ asset('public/assets/admin') }}/css/custom.css" />
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="row align-items-center mb-3">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title d-flex align-items-center g-2px text-capitalize">{{ \App\CPU\translate('recaptcha_setup') }}</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    @php($config=\App\CPU\Helpers::get_business_settings('recaptcha'))
                    <form action="{{env('APP_MODE')!='demo'?route('admin.business-settings.recaptcha-update'):'javascript:'}}" method="post">
                        @csrf
                        <div class="card-header d-flex justify-content-between">
                            <h5 class="text-uppercase mb-0">{{\App\CPU\translate('Google Recapcha Information')}}</h5>
                            <a class="btn-sm btn btn-outline-primary p-2 cursor-pointer" data-toggle="modal" data-target="#instructionsModal">
                                <i class="tio-info-outined"></i>
                                {{\App\CPU\translate('Credentials_Setup')}}
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="badge-soft-secondary rounded mb-5 p-3">
                                <h5 class="m-0">{{ \App\CPU\translate('V3 Version is available now. Must setup for ReCAPTCHA V3') }}</h5>
                                <p class="m-0">{{ \App\CPU\translate('You must setup for V3 version and active the status. Otherwise the default reCAPTCHA will be displayed automatically') }}</p>
                            </div>
                            <div class="mt-1">
                                <div class="d-flex align-items-center gap-4 gap-xl-5 mb-2">
                                    <div class="custom-radio">
                                        <input type="radio" name="status" value="1" id="status-active" {{isset($config) && $config['status'] == 1 ?'checked':''}}>
                                        <label for="status-active"> {{ \App\CPU\translate('Active') }}</label>
                                    </div>
                                    <div class="custom-radio">
                                        <input type="radio" name="status" value="0" id="status-inactive" {{isset($config) && $config['status'] == 1 ?'':'checked'}}>
                                        <label for="status-inactive"> {{ \App\CPU\translate('Inactive') }}</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="text-capitalize">{{\App\CPU\translate('Site Key')}}</label>
                                            <input type="text" class="form-control" name="site_key" value="{{env('APP_MODE')!='demo'?$config['site_key']??"":''}}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="text-capitalize">{{\App\CPU\translate('Secret Key')}}</label>
                                            <input type="text" class="form-control" name="secret_key" value="{{env('APP_MODE')!='demo'?$config['secret_key']??"":''}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <button type="{{env('APP_MODE')!='demo'?'submit':'button'}}"
                                            class="btn btn-primary demo-form-submit">{{\App\CPU\translate('save')}}</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="instructionsModal" tabindex="-1" aria-labelledby="instructionsModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-end">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center my-5">
                        <img src="{{ asset('public/assets/admin/svg/components/instruction.svg') }}">
                    </div>

                    <h5 class="modal-title my-3" id="instructionsModalLabel">{{\App\CPU\translate('Instructions')}}</h5>

                    <ol class="d-flex flex-column __gap-5px __instructions">
                        <li>{{\App\CPU\translate('To get site key and secret key go to the Credentials page')}}
                            ({{\App\CPU\translate('Click')}} <a
                                href="https://www.google.com/recaptcha/admin/create"
                                target="_blank">{{\App\CPU\translate('here')}}</a>)
                        </li>
                        <li>{{\App\CPU\translate('Add a ')}}
                            <b>{{\App\CPU\translate('label')}}</b> {{\App\CPU\translate('(Ex: Test Label)')}}
                        </li>
                        <li>
                            {{\App\CPU\translate('Select reCAPTCHA v3 as ')}}
                            <b>{{\App\CPU\translate('reCAPTCHA Type')}}</b>
                        </li>
                        <li>
                            {{\App\CPU\translate('Add')}}
                            <b>{{\App\CPU\translate('domain')}}</b>
                            {{\App\CPU\translate('(For ex: demo.6amtech.com)')}}
                        </li>
                        <li>
                            {{\App\CPU\translate('Press')}}
                            <b>{{\App\CPU\translate('Submit')}}</b>
                        </li>
                        <li>{{\App\CPU\translate('Copy')}} <b>Site
                                Key</b> {{\App\CPU\translate('and')}} <b>Secret
                                Key</b>, {{\App\CPU\translate('paste in the input filed below and')}}
                            <b>Save</b>.
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

@endsection
@push('script_2')
    <script src={{asset("public/assets/admin/js/global.js")}}></script>

    <script>
        "use strict";

        $('.demo-form-submit').on('click', function() {
            if ("{{env('APP_MODE')}}" == 'demo') {
                call_demo();            }
        });
    </script>

@endpush
