<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Models\Transection;
use App\CPU\Helpers;
use Carbon\Carbon;
use App\Models\Account;
use App\Models\Product;
use Illuminate\Pagination\Paginator;

class DashboardController extends Controller
{
    public function __construct(
        private Transection $transection,
        private Account $account,
        private Product $product
    ){}

    /**
     * @return Application|Factory|View
     */
    public function dashboard(): Factory|View|Application
    {
        $totalPayableDebit = $this->transection->where('account_id',2)->where('debit',1)->sum('amount');
        $totalPayableCredit = $this->transection->where('account_id',2)->where('credit',1)->sum('amount');
        $totalPayable = $totalPayableCredit - $totalPayableDebit;

        $totalReceivableDebit = $this->transection->where('account_id',3)->where('debit',1)->sum('amount');
        $totalReceivableCredit = $this->transection->where('account_id',3)->where('credit',1)->sum('amount');
        $totalReceivable = $totalReceivableCredit - $totalReceivableDebit;
        $totalCollection = $this->transection->where('tran_type','Income')->sum('amount');
        $totalCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->sum('amount');
        $totalIncome = $totalCollection - $totalCashRefund;

        $account = [
            'totalIncome' => $totalIncome,
            'totalExpense' => $this->transection->where('tran_type','Expense')->sum('amount'),
            'totalPayable' => $totalPayable,
            'totalReceivable' => $totalReceivable,
        ];
        $monthlyIncome=[];
        for ($i=1;$i<=12;$i++){
            $from = Carbon::create(null, $i, 1)->startOfMonth();
            $to = Carbon::create(null, $i, 1)->endOfMonth();
            $totalMonthlyCollection = $this->transection->where('tran_type','Income')->whereBetween('date', [$from, $to])->sum('amount');
            $totalMonthlyCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->whereBetween('date', [$from, $to])->sum('amount');
            $totalMonthlyIncome = $totalMonthlyCollection - $totalMonthlyCashRefund;
            $monthlyIncome[$i] = $totalMonthlyIncome;
        }
        $monthlyExpense=[];
        for ($i=1;$i<=12;$i++){
            $from = Carbon::create(null, $i, 1)->startOfMonth();
            $to = Carbon::create(null, $i, 1)->endOfMonth();
            $monthlyExpense[$i] = $this->transection->where(['tran_type'=>'Expense'])->whereBetween('date', [$from, $to])->sum('amount');
        }

        $month = date('t');
        $totalDay = Carbon::now()->daysInMonth;

        $lastMonthIncome=[];
        for($i=1;$i<=$totalDay;$i++){
            $day = date('Y-m-'.$i);
            $totalLastMonthCollection = $this->transection->where('tran_type','Income')->where('date', $day)->sum('amount');
            $totalLastMonthCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->where('date', $day)->sum('amount');
            $totalLastMonthIncome = $totalLastMonthCollection - $totalLastMonthCashRefund;
            $lastMonthIncome[$i] = $totalLastMonthIncome;
        }

        $lastMonthExpense=[];
        for($i=1;$i<=$totalDay;$i++){
            $day = date('Y-m-'.$i);
            $lastMonthExpense[$i] = $this->transection->where(['tran_type'=>'Expense'])->where('date', $day)->sum('amount');
        }

        $stockLimit = Helpers::get_business_settings('stock_limit');
        $products = $this->product->where('quantity','<',$stockLimit)->orderBy('quantity')->take(5)->get();
        $accounts = $this->account->take(5)->get();

        return view('admin-views.dashboard',compact('account','monthlyIncome','monthlyExpense','accounts','products','lastMonthIncome','lastMonthExpense','month','totalDay'));
    }

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function accountStats(Request $request): JsonResponse
    {
        if($request->statistics_type=='overall')
        {
            $totalPayableDebit = $this->transection->where('account_id',2)->where('debit',1)->sum('amount');
            $totalPayableCredit = $this->transection->where('account_id',2)->where('credit',1)->sum('amount');
            $totalPayable = $totalPayableCredit - $totalPayableDebit;

            $totalReceivableDebit = $this->transection->where('account_id',3)->where('debit',1)->sum('amount');
            $totalReceivableCredit = $this->transection->where('account_id',3)->where('credit',1)->sum('amount');
            $totalReceivable = $totalReceivableCredit - $totalReceivableDebit;
            $totalCollection = $this->transection->where('tran_type','Income')->sum('amount');
            $totalCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->sum('amount');
            $totalIncome = $totalCollection - $totalCashRefund;

            $account = [
                'totalIncome' => $totalIncome ,
                'totalExpense' => $this->transection->where('tran_type','Expense')->sum('amount'),
                'totalPayable' => $totalPayable,
                'totalReceivable' => $totalReceivable,
            ];
        }elseif ($request->statistics_type=='today') {

            $totalPayableDebit = $this->transection->where('account_id',2)->whereDate('date', '=', Carbon::now()->toDateString())->where('debit',1)->sum('amount');
            $totalPayableCredit = $this->transection->where('account_id',2)->whereDate('date', '=', Carbon::now()->toDateString())->where('credit',1)->sum('amount');
            $totalPayable = $totalPayableCredit - $totalPayableDebit;

            $totalReceivableDebit = $this->transection->where('account_id',3)->whereDate('date', '=', Carbon::now()->toDateString())->where('debit',1)->sum('amount');
            $totalReceivableCredit = $this->transection->where('account_id',3)->whereDate('date', '=', Carbon::now()->toDateString())->where('credit',1)->sum('amount');
            $totalReceivable = $totalReceivableCredit - $totalReceivableDebit;
            $totalCollection = $this->transection->where('tran_type','Income')->whereDate('date', '=', Carbon::now()->toDateString())->sum('amount');
            $totalCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->whereDate('date', '=', Carbon::now()->toDateString())->sum('amount');
            $totalIncome = $totalCollection - $totalCashRefund;

            $account = [
                'totalIncome' => $totalIncome,
                'totalExpense' => $this->transection->where('tran_type','Expense')->whereDate('date', '=', Carbon::now()->toDateString())->sum('amount'),
                'totalPayable' => $totalPayable,
                'totalReceivable' => $totalReceivable,
            ];
        }elseif ($request->statistics_type=='month') {

            $totalPayableDebit = $this->transection->where('account_id',2)->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->where('debit',1)->sum('amount');
            $totalPayableCredit = $this->transection->where('account_id',2)->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->sum('amount');
            $totalPayable = $totalPayableCredit - $totalPayableDebit;

            $totalReceivableDebit = $this->transection->where('account_id',3)->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->where('debit',1)->sum('amount');
            $totalReceivableCredit = $this->transection->where('account_id',3)->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->where('credit',1)->sum('amount');
            $totalReceivable = $totalReceivableCredit - $totalReceivableDebit;
            $totalCollection = $this->transection->where('tran_type','Income')->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->sum('amount');
            $totalCashRefund = $this->transection->where('tran_type','Refund')->where('account_id',1)->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->sum('amount');
            $totalIncome = $totalCollection - $totalCashRefund;

            $account = [
                'totalIncome' => $totalIncome,
                'totalExpense' => $this->transection->where('tran_type','Expense')->whereMonth('date', Carbon::now()->month)->whereYear('date', Carbon::now()->year)->sum('amount'),
                'totalPayable' => $totalPayable,
                'totalReceivable' => $totalReceivable,
            ];
        }
        return response()->json([
            'view'=> view('admin-views.partials._dashboard-balance-stats',compact('account'))->render()
        ],200);
    }

}
