@extends('layouts.admin.app')

@section('title',\App\CPU\translate('counter details'))

@push('css_or_js')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css"/>
    <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/custom.css"/>
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="">
            <div class="row align-items-center mb-3">
                <div class="col-sm-12 mb-2 mb-sm-0">
                    <h1 class="fs-16">
                        <span>{{\App\CPU\translate('counter details')}}</span>
                    </h1>
                </div>
            </div>
        </div>
        <div class="card counter-details mb-4">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6 mt-3">
                        <div class="d-flex align-items-center">
                            <img src="{{asset('public/assets/admin/img/counter-user.png')}}" alt="Counter Image">
                            <div class="w-0 flex-grow-1 pl-3">
                                <h4 class="counter-details-title">{{$counter['name']}} - {{ $counter['number'] }}</h4>
                                <p class="counter-details-text">{{$counter['description']}}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-sm-6 mt-3">
                                <a class="card card-hover-shadow h-100 bg-blue" href="#">
                                    <div class="card-body">
                                        <div class="d-flex flex-column align-items-center">
                                            <h6 class="card-subtitle text-center">{{\App\CPU\translate('Total_order')}}</h6>
                                            <span class="card-title text-center">
                                                {{$counter->orders_count}}
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-sm-6 mt-3">
                                <a class="card card-hover-shadow h-100 bg-green" href="#">
                                    <div class="card-body">
                                        <div class="d-flex flex-column align-items-center">
                                            <h6 class="card-subtitle text-center">{{\App\CPU\translate('Total_Earning')}}</h6>
                                            <span class="card-title text-center">
                                                {{ ($counter->orders_sum_order_amount ?? 0) + ($counter->orders_sum_total_tax ?? 0) }} {{ \App\CPU\Helpers::currency_symbol() }}
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-2 mb-4">
            <h2 class="page-header-title fs-16 text-capitalize">{{\App\CPU\translate('order_list')}}
                <span class="badge bg-primary ml-2 rounded-full text-white">{{ $orders->total() }}</span></h2>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="row justify-content-between align-items-center w-100">
                    <div class="col-12 col-md-8 col-sm-12">
                        <div class="d-flex align-items-start flex-wrap gx-2">
                            <form action="{{ url()->current() }}" method="GET" class="w-100 w-md-auto">
                                <div class="input-group input-group-merge input-group-flush mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input id="datatableSearch_" type="text" name="search" class="form-control"
                                           placeholder="{{ \App\CPU\translate('search') }}"
                                           aria-label="{{ \App\CPU\translate('Search') }}"
                                           value="{{ request()->search ?? '' }}">
                                    <button type="submit" class="btn btn-primary">
                                        {{ \App\CPU\translate('search') }}
                                    </button>
                                </div>
                            </form>

                            <button type="button" class="btn btn-white mb-2" id="reportrange">
                                <img class="svg" src="{{ asset('public/assets/admin/img/clock.svg') }}" alt="">
                                <span></span>
                            </button>
                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-sm-12">
                        <div class="d-flex justify-content-end">
                            <a class="btn btn-white mr-2"
                               href="{{ route('admin.counter.export', ['id' => $counter->id,'start_date' => request()->start_date, 'end_date' => request()->end_date, 'search' => request()->search]) }}">
                                {{\App\CPU\translate('Export')}}
                                <i class="tio-download"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom counter-table">
                <table
                    class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th>{{ \App\CPU\translate('#') }}</th>
                        <th>{{ \App\CPU\translate('order_id') }}</th>
                        <th>{{ \App\CPU\translate('order_date') }}</th>
                        <th>{{ \App\CPU\translate('Customer_Info') }}</th>
                        <th class="text-center">{{ \App\CPU\translate('Total_Amount') }}</th>
                        <th class="text-center">{{ \App\CPU\translate('Paid_By') }}</th>
                        <th class="text-center">{{ \App\CPU\translate('Action') }}</th>
                    </tr>
                    </thead>

                    <tbody id="set-rows">
                    @foreach($orders as $key => $order)
                        <tr>
                            <td>{{ $orders->firstitem()+$key }}</td>
                            <td>#{{ $order['id'] }}</td>

                            <td>{{date('d M Y',strtotime($order['created_at']))}}</td>
                            <td>
                                @if($order->user_id != 0)
                                    @if($order->customer)
                                        {{ $order?->customer?->name }}
                                        <br>
                                        {{ $order?->customer?->mobile }}
                                    @else
                                        <span
                                            class="badge badge-danger">{{ \App\CPU\translate('Customer_Deleted') }}</span>
                                    @endif
                                @else
                                    {{ \App\CPU\translate('Walk-In_Customer') }}
                                @endif
                            </td>
                            <td class="text-center">
                                {{ number_format($order->order_amount + $order->total_tax - $order->coupon_discount_amount - ($order->extra_discount ?? 0), 2) . ' ' . \App\CPU\Helpers::currency_symbol()}}
                            </td>
                            <td class="text-center text-capitalize">
                                {{ ($order->payment_id != 0) ? ($order->account ? $order->account->account : \App\CPU\translate('account_deleted')): \App\CPU\translate('Customer balance') }}
                            </td>
                            <td>
                                <div class="d-flex justify-content-center gap-2">
                                    <button class="btn btn-sm btn-white print-invoice" target="_blank" type="button"
                                            data-id="{{$order->id}}"><i
                                            class="tio-download"></i> {{\App\CPU\translate('invoice')}}
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                <div class="card-footer">
                    <div class="row justify-content-center justify-content-sm-end align-items-sm-center">
                        <div class="col-sm-auto">
                            <div class="d-flex justify-content-center justify-content-sm-end">
                                {!! $orders->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
                @if(count($orders)==0)
                    <div class="text-center p-4">
                        <img class="mb-3 img-one-ol" src="{{asset('public/assets/admin')}}/svg/illustrations/sorry.svg"
                             alt="Image Description">
                        <p class="mb-0">{{ \App\CPU\translate('No_data_to_show')}}</p>
                    </div>
                @endif
            </div>
        </div>

    </div>

    <div class="modal fade" id="print-invoice" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content modal-content1">
                <div class="modal-header">
                    <h5 class="modal-title">{{\App\CPU\translate('print')}} {{\App\CPU\translate('invoice')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span class="text-dark" aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body row">
                    <div class="col-md-12">
                        <div class="text-center">
                            <input type="button" class="mt-2 btn btn-primary non-printable print-div"
                                   data-name="printableArea"
                                   value="{{\App\CPU\translate('Proceed, If thermal printer is ready')}}."/>
                            <a href="{{url()->previous()}}"
                               class="mt-2 btn btn-danger non-printable">{{\App\CPU\translate('Back')}}</a>
                        </div>
                        <hr class="non-printable">
                    </div>
                    <div class="row m-auto" id="printableArea">

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script_2')
    <script src={{asset("public/assets/admin/js/global.js")}}></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script type="text/javascript">
        $(function () {
            let currentUrl = new URL(window.location.href);
            let searchQuery = currentUrl.searchParams.get('search') || ''; // Get search query
            let startDateFromUrl = currentUrl.searchParams.get('start_date');
            let endDateFromUrl = currentUrl.searchParams.get('end_date');
            let startDate = startDateFromUrl ? moment(startDateFromUrl, 'YYYY-MM-DD') : null;
            let endDate = endDateFromUrl ? moment(endDateFromUrl, 'YYYY-MM-DD') : null;

            // Set date range text
            if (!startDate || !endDate) {
                $('#reportrange span').html('Select Date');
            } else {
                $('#reportrange span').html(startDate.format('DD MMM, YYYY') + ' - ' + endDate.format('DD MMM, YYYY'));
            }

            $('#reportrange').daterangepicker({
                autoUpdateInput: false,
                startDate: startDate || moment(),
                endDate: endDate || moment(),
                locale: {
                    cancelLabel: 'Clear'
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            });

            // Apply new date range & keep search query
            $('#reportrange').on('apply.daterangepicker', function (ev, picker) {
                $(this).find('span').html(picker.startDate.format('DD MMM, YYYY') + ' - ' + picker.endDate.format('DD MMM, YYYY'));

                let currentUrl = new URL(window.location.href);
                currentUrl.searchParams.delete('page'); // Reset pagination
                currentUrl.searchParams.set('start_date', picker.startDate.format('YYYY-MM-DD'));
                currentUrl.searchParams.set('end_date', picker.endDate.format('YYYY-MM-DD'));

                if (searchQuery) {
                    currentUrl.searchParams.set('search', searchQuery); // Keep search term
                }

                window.location.href = currentUrl.toString();
            });

            // Clear date range & keep search query
            $('#reportrange').on('cancel.daterangepicker', function (ev, picker) {
                $(this).find('span').html('Select Date');

                let currentUrl = new URL(window.location.href);
                currentUrl.searchParams.delete('page');
                currentUrl.searchParams.delete('start_date');
                currentUrl.searchParams.delete('end_date');

                if (searchQuery) {
                    currentUrl.searchParams.set('search', searchQuery);
                }

                window.location.href = currentUrl.toString();
            });

            // Ensure search form submits along with selected date range
            $('form').on('submit', function (e) {
                let currentUrl = new URL(window.location.href);
                let searchInput = $('#datatableSearch_').val();

                if (searchInput) {
                    currentUrl.searchParams.set('search', searchInput);
                } else {
                    currentUrl.searchParams.delete('search');
                }

                if (startDateFromUrl) {
                    currentUrl.searchParams.set('start_date', startDateFromUrl);
                }
                if (endDateFromUrl) {
                    currentUrl.searchParams.set('end_date', endDateFromUrl);
                }

                window.location.href = currentUrl.toString();
                e.preventDefault(); // Prevent default form submission
            });
        });
    </script>

    <script>
        "use strict";
        $(".print-invoice").on('click', function () {
            let order_id = $(this).data('id');
            print_invoice(order_id);
        });

        function print_invoice(order_id) {
            $.get({
                url: '{{url('/')}}/admin/pos/invoice/' + order_id,
                dataType: 'json',
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    $('#print-invoice').modal('show');
                    $('#printableArea').empty().html(data.view);
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }

        function replaceSvgImages() {
            $('img.svg').each(function () {
                let $img = $(this);
                let imgURL = $img.attr('src');

                $.get(imgURL, function (data) {
                    let $svg = $(data).find('svg');

                    if ($img.attr('class')) {
                        $svg.attr('class', $img.attr('class'));
                    }
                    $svg.removeAttr('xmlns:a');

                    $img.replaceWith($svg);
                }, 'xml');
            });
        }

        replaceSvgImages();
    </script>
@endpush
