<?php

use Illuminate\Support\Facades\Storage;

if (!function_exists('displayImage')) {
    function displayImage($image, $isAvatar = false)
    {
        if (file_exists($image) && is_file($image)) {
            return asset($image);
        } elseif ($isAvatar) {
            return asset('public/assets/admin/img/160x160/img1.jpg');
        } else {
            return asset('public/assets/admin/img/160x160/img1.jpg');
        }
    }
}

if (!function_exists('onErrorImage')) {
    function onErrorImage($data, $src, $error_src ,$path)
    {
        if(isset($data) && strlen($data) >1 && Storage::disk('public')->exists($path. '/' .$data)){
            return $src;
        }
        return $error_src;
    }
}

if (!function_exists('getSorting'))
{
    function getSorting(string $sortingType)
    {
        $sortOptions = [
            'latest' => ['id', 'desc'],
            'oldest' => ['id', 'asc'],
            'ascending' => ['name', 'asc'],
            'descending' => ['name', 'desc'],
        ];

        return $sortOptions[$sortingType] ?? ['id', 'desc'];
    }
}

if (!function_exists('getExportColumnMap')) {
    function getExportColumnMap()
    {
        return [
            'sl' => fn($index) => [
                'SL' => $index,
            ],
            'name' => fn($resource) => [
                'Name' => $resource->name,
            ],
            'parent_name' => fn($resource) => [
                'Parent Category' => $resource->parent ? $resource->parent->name : 'No parent category',
            ],
            'description' => fn($resource) => [
                'Description' => $resource->description ?? '',
            ],
            'product_count' => fn($resource) => [
                'Total Product' => $resource->product_count ?? 0,
            ],
            'status' => fn($resource) => [
                'Status' => $resource->status ? 'Active' : 'Inactive',
            ],
            'supplier_info' => fn($resource) => [
                'Supplier' => $resource?->supplier ? $resource->supplier->name . ' (' . $resource->supplier->mobile . ')' : 'No supplier',
            ],
            'category' => fn($resource) => [
                'Category' => $resource->category ? $resource->category->name : 'No category',
            ],
            'quantity' => fn($resource) => [
                'Quantity' => $resource->quantity,
            ],
            'total_ordered' => fn($resource) => [
                'Total Ordered' => $resource->order_count ?? 0,
            ],
            'stock_status' => fn($resource) => [
                'Stock Status' => $resource->quantity == 0 ? 'Out of Stock' : 'Low Stock',
            ],
            'purchase_price' => fn($resource) => [
                'Purchase Price' => $resource->purchase_price ? \App\CPU\Helpers::currency_symbol() . ' ' . number_format($resource->purchase_price, 2) : 'N/A',
            ],

            'selling_price' => fn($resource) => [
                'Selling Price' => $resource->selling_price ? \App\CPU\Helpers::currency_symbol() . ' ' . number_format($resource->selling_price, 2) : 'N/A',
            ],
        ];
    }
}

if (!function_exists('shortNumberFormat')) {
    function shortNumberFormat($number, $precision = 1)
    {
        if (!is_numeric($number)) return $number;

        if ($number < 1000) {
            return (string) $number;
        }

        $units = [
            12 => 't',
            9  => 'b',
            6  => 'm',
            3  => 'k',
        ];

        foreach ($units as $exponent => $suffix) {
            if ($number >= pow(10, $exponent)) {
                return round($number / pow(10, $exponent), $precision) . $suffix;
            }
        }

        return (string) $number;
    }

}

